/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.tests.dao;

import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IDao;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.AbstractCapabilityVO;
import com.quantumdata.sct.dao.vo.ModelCapabilityVO;
import com.quantumdata.sct.util.keygen.DefaultKeyGenerator;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ModelCapabilityDAOTest
extends TestCase {
    private IDao dao = null;
    private boolean bInitialize = false;

    public ModelCapabilityDAOTest(String string) {
        super(string);
    }

    protected void setUp() {
        try {
            System.setProperty(XMLDAOFactory.dataFileEnv, "." + System.getProperty("file.separator") + "Properties.props");
            this.dao = XMLDAOFactory.getModelCapabilityDAO();
            this.bInitialize = true;
        }
        catch (Exception exception) {
            this.bInitialize = false;
        }
    }

    public void readAllTest() {
        boolean bl = false;
        try {
            IPersistable[] iPersistableArray = this.dao.readAll();
            System.out.println(iPersistableArray.length);
            if (iPersistableArray.length > 0) {
                for (int i = 0; i < iPersistableArray.length; ++i) {
                    IPersistable iPersistable = iPersistableArray[i];
                    System.out.println(iPersistable.getId());
                }
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        ModelCapabilityDAOTest.assertEquals(bl, false);
    }

    public void readTest() {
        boolean bl = false;
        String string = "ID1";
        try {
            IPersistable iPersistable = this.dao.read(string);
            bl = !iPersistable.getId().equals(string);
            System.out.println(iPersistable.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        ModelCapabilityDAOTest.assertEquals(bl, false);
    }

    public void insertTest() throws Exception {
        boolean bl = false;
        DefaultKeyGenerator defaultKeyGenerator = new DefaultKeyGenerator();
        String string = defaultKeyGenerator.generateUniqueKey();
        ModelCapabilityVO modelCapabilityVO = new ModelCapabilityVO();
        modelCapabilityVO.setLastUpdate(System.currentTimeMillis());
        modelCapabilityVO.setId(string);
        IDao iDao = XMLDAOFactory.getCapabilityDAO();
        IPersistable[] iPersistableArray = iDao.readAll();
        int n = iPersistableArray.length;
        ArrayList<ModelCapabilityVO.ModelCapabilityElementVO> arrayList = new ArrayList<ModelCapabilityVO.ModelCapabilityElementVO>();
        for (int i = 0; i < n; ++i) {
            AbstractCapabilityVO abstractCapabilityVO = (AbstractCapabilityVO)((Object)iPersistableArray[i]);
            ModelCapabilityVO.ModelCapabilityElementVO modelCapabilityElementVO = new ModelCapabilityVO.ModelCapabilityElementVO();
            modelCapabilityElementVO.setName("param" + String.valueOf(i));
            modelCapabilityElementVO.setValue("value" + String.valueOf(i));
            modelCapabilityElementVO.setOutput(false);
            modelCapabilityElementVO.setUserInput(false);
            modelCapabilityElementVO.setSupported(true);
            modelCapabilityElementVO.setCapabilityId((String)abstractCapabilityVO.getId());
            arrayList.add(modelCapabilityElementVO);
        }
        modelCapabilityVO.setCapabilities(arrayList);
        this.dao.add(modelCapabilityVO);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new ModelCapabilityDAOTest("readTest"));
        testSuite.addTest(new ModelCapabilityDAOTest("readAllTest"));
        testSuite.addTest(new ModelCapabilityDAOTest("insertTest"));
        return testSuite;
    }
}

